# Chrome History Wrapped 2025

A simple Chrome extension that exports your 2025 browsing history to a JSON file.

## Installation

1. Open Chrome and navigate to `chrome://extensions`
2. Enable **Developer mode** (toggle in top right)
3. Click **Load unpacked**
4. Select the `chrome-history-wrapped-2025` folder
5. Pin the extension to your toolbar for easy access

## Usage

1. Click the extension icon in your toolbar
2. The extension will automatically:
   - Query all history entries from January 1, 2025 to January 1, 2026
   - Export them to `chrome-history-2025.json`
   - Download the file to your Downloads folder

## Output Format

The exported JSON file contains:

```json
{
  "exportDate": "2025-12-09T12:00:00.000Z",
  "year": 2025,
  "totalEntries": 1234,
  "history": [
    {
      "url": "https://example.com/page",
      "title": "Page Title",
      "lastVisitTime": 1704067200000,
      "lastVisitDate": "2025-01-01T00:00:00.000Z",
      "visitCount": 5,
      "typedCount": 2,
      "hostname": "example.com"
    }
  ]
}
```

## Fields Explained

- **url**: Full URL of the visited page
- **title**: Page title
- **lastVisitTime**: Unix timestamp (milliseconds) of last visit
- **lastVisitDate**: ISO 8601 formatted date of last visit
- **visitCount**: Total number of visits to this URL
- **typedCount**: Number of times URL was typed directly
- **hostname**: Extracted domain name

## Permissions

This extension requires:
- **history**: To read your browsing history
- **downloads**: To save the JSON file

## Troubleshooting

- **No file downloaded**: Check the Chrome console (right-click extension icon → Inspect popup → Console) for errors
- **Empty history**: Ensure you have browsing history from 2025
- **Extension not appearing**: Make sure Developer mode is enabled and the extension is loaded

## Privacy

All data processing happens locally in your browser. No data is sent to any external servers.
